@extends('layouts.frontend')
@section('meta_info')
    <title>{{ setting('site_title') }}</title>
    <meta name="description" content="{{ setting('meta_description') }}">
    <meta name="keywords" content="{{ setting('meta_keywords') }}">
    <meta name="author" content="{{ setting('meta_author') }}">
@endsection

<style>
    .contact__input{
        margin-bottom: 20px;
    }
</style>
@section('content')
    <section class="pg__contact position-relative">
        <iframe
            src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d721.4247280032394!2d90.393694!3d23.779508!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755c7435b139447%3A0xf0328f2b4231ba48!2sParadigm%20Group!5e1!3m2!1sen!2sbd!4v1755974658949!5m2!1sen!2sbd"
            width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"></iframe>
    </section>

    <section class="position-relative bg-secondary">
        <div class="container position-relative zindex-2">
            <div class="row">
                <div class="col-xl-4 col-lg-5 pb-4 pb-sm-5 mb-2 mb-sm-0">
                    <p><!-----bangladesh Office-----></p>
                    <div class="col-md-12">
                        <h3>Bangladesh Office</h3>
                        <ul class="contact-info">
                            <li class="margin5"><i class="icon-map"></i>House No-421(1st Floor), Road No- 30, New DOHS,
                                Mohakhali, Dhaka.
                            </li>
                            <li class="margin5"><i class="icon-phone"></i>+8802-9889757,+8801919515033,+8801919515030
                            </li>
                            <li class="margin5"><i class="icon-envelope"></i> Email: idea.com.bd@gmail.com</li>
                            <h3>Malaysia Office</h3>
                            <li class="margin5"><i class="icon-map"></i>10 Plaza Usahawan, Jalan Danau Niaga 1, Danau
                                Kota, 53300, Kualam Lumpur, Malaysia.
                            </li>
                            <li class="margin5"><i class="icon-phone"></i>Mobile:+6011142775129, +601133161920</li>
                            <li class="margin5"><i class="icon-envelope"></i> Email: idea.com.bd@gmail.com</li>
                            <h3> Our Factory</h3>
                            <li class="margin5"><i class="icon-map"></i>25/A/3, Purana Paltan Line, Dhaka-1000
                            </li>
                            <li class="margin5"><i class="icon-phone"></i>Ph: 02-57161052</li>
                        </ul>
                    </div>
                </div>

                <!-- Contact form -->
                <div class="col-xl-6 col-lg-7 offset-xl-2">
                    <div class="card border-light shadow-lg py-3 p-sm-4 p-md-5">
                        <div
                            class="bg-dark position-absolute top-0 start-0 w-100 h-100 rounded-3 d-none d-dark-mode-block"></div>
                        <div class="card-body position-relative zindex-2">
                            <h2 class="card-title pb-3 mb-4">Have any Query?</h2>
                            @if (session('success'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('success') }}
                                </div>
                            @endif

                            @if (session('status'))
                                <div class="alert alert-success" role="alert">
                                    {{ session('status') }}
                                </div>
                            @endif

                            <form class="needs-validation " method="POST" action="{{ route('message') }}">
                                @csrf
                                <div class="col-12 mb-4 contact__input">
                                    <label for="fn" class="form-label fs-base">Full Name <span
                                            class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="fn" name="name"
                                           value="{{ old('name') }}" maxlength="30" required>
                                    @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-12 mb-4 contact__input">
                                    <label for="email" class="form-label fs-base">Email Address</label>
                                    <input type="email" class="form-control" id="email" name="email"
                                           value="{{ old('email') }}" maxlength="100" required>
                                    @error('email')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-12 mb-3 contact__input">
                                    <label for="email" class="form-label fs-base">Message</label>
                                    <textarea id="message" class="form-control" rows="4" name="message" maxlength="300"
                                              required>{{ old('message') }}</textarea>
                                    @error('message')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-12 pt-2 pt-sm-3">
                                    <button type="submit" class="btn btn-outline-primary text-uppercase">
                                        Send
                                        <i class="bx bx-right-arrow-alt fs-xl ms-2 me-n1"></i>
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="position-absolute bottom-0 start-0 w-100 bg-light" style="height: 8rem;"></div>
    </section>
@endsection
